/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties;

import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.PropertyImpl;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.container.HasEventManager;
import net.java.dev.properties.events.PropertyListener;

public abstract class LazyProperty<T>
extends PropertyImpl<T> {
    private boolean _initialized = false;

    public LazyProperty() {
    }

    public LazyProperty(WProperty<?> ... wPropertyArray) {
        for (WProperty<?> wProperty : wPropertyArray) {
            ((HasEventManager)((Object)wProperty)).getEventManager().addListener(new PropertyListener(){

                @Override
                public void propertyChanged(BaseProperty baseProperty, Object object, Object object2, int n) {
                    LazyProperty.this._initialized = false;
                }
            });
        }
    }

    @Override
    public T get() {
        if (!this._initialized) {
            this.set(this.init());
        }
        return super.get();
    }

    public void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    public abstract T init();

    @Override
    public void set(T t) {
        this._initialized = true;
        super.set(t);
    }

    public void reset() {
        this._initialized = false;
    }
}

