/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client.hermes;

import a8.hermes.Client;
import a8.hermes.LongPollClient;
import a8.hermes.MessageReceiver;
import a8.hermes.protocol.Message;
import a8.hermes.protocol.PubPrivPair;
import a8.hermes.protocol.PublicMailboxId;
import a8.hermes.protocol.SendMessageRequest;
import a8.hermes.protocol.SendMessageResponse;
import com.ahsrcm.batchviewer.client.action.ClientActionEnum;
import com.ahsrcm.batchviewer.client.direct.VmActionEnum;
import com.ahsrcm.batchviewer.client.hermes.BackoffService;
import com.ahsrcm.batchviewer.client.hermes.HermesConfig;
import com.ahsrcm.client.scanning.gui.PanelPopupHelper;
import com.ahsrcm.core.hermes.ClientActionMessage;
import com.ahsrcm.core.hermes.NotifyAgentMessage;
import com.ahsrcm.core.hermes.RegisterMessage;
import com.ahsrcm.core.hermes.VmActionMessage;
import com.ahsrcm.scanning.app.client.beans.IvrInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;

@Singleton
public class ClientHermesClient {
    private static final Logger logger = LoggerHelper.getLogger();
    private final Gson _gson = new Gson();
    private final AtomicBoolean _isStarted = new AtomicBoolean(false);
    private final ThreadScheduler _threadScheduler;
    private String _eaxUserUid;
    private UrlX _hermesConfigUrl;
    private Client _client;
    private PublicMailboxId _serverMailboxId;
    private PubPrivPair _mailbox;
    @Inject
    private PanelPopupHelper _panelPopupHelper;

    @Inject
    public ClientHermesClient(ThreadScheduler threadScheduler) {
        this._threadScheduler = threadScheduler;
    }

    public void start(UrlX urlX, String string) {
        if (this._isStarted.compareAndSet(false, true)) {
            this._hermesConfigUrl = urlX.subPath("api").subPath("ivr").subPath("hermesConfig");
            this._eaxUserUid = string;
            this._threadScheduler.schedule("HermesClient", TimeDuration.fromMilliseconds((long)0L), (Runnable)new RegisterRunnable());
        }
    }

    public boolean registerHermes() {
        try {
            Object object;
            URI uRI;
            String string = this._hermesConfigUrl.getContentAsString();
            HermesConfig hermesConfig = (HermesConfig)this._gson.fromJson(string, HermesConfig.class);
            if (this._client == null) {
                uRI = new URI(hermesConfig.getHermesServerUri());
                object = new MessageReceiverImpl();
                this._client = new LongPollClient(uRI, (MessageReceiver)object);
                this._client.start();
                this._mailbox = this._client.getMailbox();
                logger.info((Object)("Using mailbox " + this._mailbox.toString()));
            }
            if (this._serverMailboxId == null || this._serverMailboxId.getValue() == null || !this._serverMailboxId.getValue().equals(hermesConfig.getServerMailboxId()) || !this._mailbox.equals((Object)this._client.getMailbox())) {
                this._serverMailboxId = new PublicMailboxId(hermesConfig.getServerMailboxId());
                this._mailbox = this._client.getMailbox();
                logger.info((Object)("Sending registration for user " + this._eaxUserUid + " to mailbox " + this._serverMailboxId.getValue()));
                uRI = new RegisterMessage(this._eaxUserUid);
                object = new HashMap();
                object.put("type", "Register");
                JsonObject jsonObject = (JsonObject)this._gson.toJsonTree((Object)uRI);
                SendMessageRequest sendMessageRequest = new SendMessageRequest(Collections.singletonList(this._serverMailboxId.getValue()), (Map)object, jsonObject);
                SendMessageResponse sendMessageResponse = this._client.send(sendMessageRequest);
                return sendMessageResponse.getFailures().isEmpty();
            }
            return true;
        }
        catch (Exception exception) {
            logger.warn((Object)"Error registering hermes client", (Object)exception);
            return false;
        }
    }

    public Client getClient() {
        return this._client;
    }

    public PublicMailboxId getServerMailboxId() {
        return this._serverMailboxId;
    }

    public class MessageReceiverImpl
    implements MessageReceiver {
        public void receiveFn(Message message) {
            String string = (String)message.getHeaders().get("type");
            if (string.equals("NotifyAgent")) {
                NotifyAgentMessage notifyAgentMessage = (NotifyAgentMessage)ClientHermesClient.this._gson.fromJson((JsonElement)message.getBody(), NotifyAgentMessage.class);
                logger.debug((Object)("Received NotifyAgentMessage -- Company: " + notifyAgentMessage.getCompanyId() + ", Division: " + notifyAgentMessage.getDivisionId() + ", Patient ID: " + notifyAgentMessage.getPatientId()));
                IvrInfo ivrInfo = new IvrInfo(notifyAgentMessage);
                ClientHermesClient.this._panelPopupHelper.showIvrPage(ivrInfo);
            } else if (string.equals("VmAction")) {
                VmActionMessage vmActionMessage = (VmActionMessage)ClientHermesClient.this._gson.fromJson((JsonElement)message.getBody(), VmActionMessage.class);
                String string2 = "";
                if (vmActionMessage.getPatientFileId() != null) {
                    string2 = " patientFileId: " + vmActionMessage.getPatientFileId();
                }
                String string3 = "Received DeployEdgeDirectActionMessage -- action: " + vmActionMessage.getAction() + string2;
                logger.debug((Object)string3);
                VmActionEnum.enactDeployEdgeDirectAction(vmActionMessage);
            } else if (string.equals("ClientAction")) {
                try {
                    ClientActionMessage clientActionMessage = (ClientActionMessage)ClientHermesClient.this._gson.fromJson((JsonElement)message.getBody(), ClientActionMessage.class);
                    ClientActionEnum clientActionEnum = ClientActionEnum.enumFromString(clientActionMessage.getAction());
                    clientActionEnum.takeAction(clientActionMessage);
                }
                catch (Exception exception) {
                    logger.warn((Object)"ClientActionMessage -- message action failed", (Object)exception);
                }
            } else {
                logger.warn((Object)("currently unable to process message type '" + string + "'"));
            }
        }
    }

    public class RegisterRunnable
    implements Runnable {
        @Override
        public void run() {
            int n = 5;
            long l = TimeDuration.fromSeconds((double)60.0).inMilliseconds();
            double d = 2.0;
            BackoffService backoffService = new BackoffService(n, l, d, true);
            while (backoffService.shouldRetry()) {
                boolean bl = ClientHermesClient.this.registerHermes();
                if (bl) {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    backoffService.reset();
                    continue;
                }
                backoffService.errorOccurred();
            }
        }
    }
}

