/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client.hermes;

import java.util.Random;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class BackoffService {
    private static final Logger logger = LoggerHelper.getLogger();
    public static int defaultRetries = 2;
    public static long defaultHeartBeatTime = 10000L;
    private int _numberOfRetries;
    private int _numberOfTriesLeft;
    private long _heartBeatTime;
    private long _retryTime;
    private int _originalNumberOfRetries;
    private double _exponentialMultiplier;
    private boolean _resetAfterAttempts;
    private final Random random = new Random();

    public BackoffService() {
        this(defaultRetries, defaultHeartBeatTime, 1.0, false);
    }

    public BackoffService(int n, long l, double d, boolean bl) {
        this._numberOfRetries = n;
        this._numberOfTriesLeft = n;
        this._heartBeatTime = l;
        this._retryTime = l;
        this._originalNumberOfRetries = n;
        this._exponentialMultiplier = d;
        this._resetAfterAttempts = bl;
        TimeDuration timeDuration = TimeDuration.fromMilliseconds((long)this.getExponentialRetryTime(n));
        logger.debug((Object)"max reset time in is {}", (Object)timeDuration.asVerboseText());
    }

    public boolean shouldRetry() {
        return this._numberOfTriesLeft > 0;
    }

    public int numberOfErrors() {
        return this._originalNumberOfRetries - this._numberOfTriesLeft;
    }

    public void errorOccurred() {
        --this._numberOfTriesLeft;
        if (!this.shouldRetry()) {
            logger.debug((Object)"errorOccurred -- retries FAILED");
            if (this._resetAfterAttempts) {
                this.reset();
            }
        } else {
            logger.debug((Object)"errorOccurred -- Retrying");
        }
        boolean bl = this._exponentialMultiplier > 1.0;
        long l = this.getRetryTime();
        if (bl) {
            l = this.getExponentialRetryTime(this.numberOfErrors());
        }
        this.waitUntilNextTry(l);
        this._retryTime += (long)this.random.nextInt(1000);
    }

    private void waitUntilNextTry(long l) {
        try {
            logger.debug((Object)"waitUntilNextTry -- retryTime = {} ms", (Object)l);
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private long getExponentialRetryTime(int n) {
        Double d = Math.pow(this._exponentialMultiplier, n);
        return this.getRetryTime() * d.longValue();
    }

    public long getRetryTime() {
        return this._retryTime;
    }

    public void doNotRetry() {
        this._numberOfTriesLeft = 0;
    }

    public void reset() {
        logger.debug((Object)"resetting backoff service retry time: {} ms", (Object)this._heartBeatTime);
        this._numberOfTriesLeft = this._numberOfRetries;
        this._retryTime = this._heartBeatTime;
    }
}

