/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client.direct;

import com.ahsrcm.batchviewer.client.BatchViewerPanel;
import com.ahsrcm.batchviewer.client.BatchViewerWindow;
import com.ahsrcm.client.scanning.gui.PanelPopupHelper;
import com.ahsrcm.core.hermes.VmActionMessage;
import java.awt.Window;
import java.util.List;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public enum VmActionEnum {
    NextPage{

        @Override
        public void takeAction(VmActionMessage vmActionMessage) {
            BatchViewerWindow batchViewerWindow = (BatchViewerWindow)DependencyInjector.getInstance(BatchViewerWindow.class);
            batchViewerWindow.getBatchViewerPanel().nextPage();
        }
    }
    ,
    PreviousPage{

        @Override
        public void takeAction(VmActionMessage vmActionMessage) {
            BatchViewerWindow batchViewerWindow = (BatchViewerWindow)DependencyInjector.getInstance(BatchViewerWindow.class);
            batchViewerWindow.getBatchViewerPanel().previousPage();
        }
    }
    ,
    LoadPatientFile{

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void takeAction(VmActionMessage vmActionMessage) {
            if (vmActionMessage.getPatientFileId() == null || vmActionMessage.getPatientFileId().trim().equals("")) throw new RuntimeException("unable to open patient file because no patientFileId was sent in the message=" + vmActionMessage);
            BatchViewerWindow batchViewerWindow = (BatchViewerWindow)DependencyInjector.getInstance(BatchViewerWindow.class);
            if (vmActionMessage.getPatientFileId() == null || vmActionMessage.getPatientFileId().trim().equals("")) throw new RuntimeException("unable to open patient file because no patientFileId was sent in the message=" + vmActionMessage);
            long l = Long.parseLong(vmActionMessage.getPatientFileId());
            BatchViewerPanel batchViewerPanel = batchViewerWindow.getBatchViewerPanel();
            if (batchViewerPanel == null) {
                PanelPopupHelper panelPopupHelper = (PanelPopupHelper)DependencyInjector.getInstance(PanelPopupHelper.class);
                List list = panelPopupHelper.getVisibleWindows();
                for (Window window : list) {
                    window.setVisible(false);
                    window.dispose();
                }
                batchViewerWindow.setupAndShow(l);
            }
            batchViewerWindow.getBatchViewerPanel().loadPatientFile(vmActionMessage.getPatientFileId());
        }
    }
    ,
    CloseApp{

        @Override
        public void takeAction(VmActionMessage vmActionMessage) {
            BatchViewerWindow batchViewerWindow = (BatchViewerWindow)DependencyInjector.getInstance(BatchViewerWindow.class);
            batchViewerWindow.closeWindow();
        }
    };

    private static final Logger logger;

    public abstract void takeAction(VmActionMessage var1);

    public static VmActionEnum enumFromAction(String string) {
        VmActionEnum vmActionEnum = null;
        if ("NEXT_IMAGE".equalsIgnoreCase(string)) {
            vmActionEnum = NextPage;
        } else if ("PREVIOUS_IMAGE".equalsIgnoreCase(string)) {
            vmActionEnum = PreviousPage;
        } else if ("LOAD_PATIENT_FILE".equalsIgnoreCase(string)) {
            vmActionEnum = LoadPatientFile;
        } else if ("CLOSE".equalsIgnoreCase(string)) {
            vmActionEnum = CloseApp;
        } else {
            logger.error((Object)("don't know how to handle '" + string + "'"));
        }
        return vmActionEnum;
    }

    public static void enactDeployEdgeDirectAction(VmActionMessage vmActionMessage) {
        try {
            String string = vmActionMessage.getAction();
            VmActionEnum vmActionEnum = VmActionEnum.enumFromAction(string);
            vmActionEnum.takeAction(vmActionMessage);
        }
        catch (Exception exception) {
            logger.error((Object)"unable to perform deployedge direct action", (Object)exception);
        }
    }

    static {
        logger = LoggerHelper.getLogger();
    }
}

