/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client.action;

import com.ahsrcm.batchviewer.client.action.ShowCodingParms;
import com.ahsrcm.batchviewer.client.action.ShowScanBatch;
import com.ahsrcm.core.hermes.ClientActionMessage;
import com.ahsrcm.scanning.app.client.TaskPlugin;
import com.google.gson.Gson;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public enum ClientActionEnum {
    CreateScanBatch{

        @Override
        public void takeAction(ClientActionMessage clientActionMessage) {
            logger.debug((Object)"Received CreateScanBatchMessage");
            taskPlugin.showCreateScanBatch();
        }
    }
    ,
    ShowCoding{

        @Override
        public void takeAction(ClientActionMessage clientActionMessage) {
            ShowCodingParms showCodingParms = (ShowCodingParms)gson.fromJson(clientActionMessage.getParmsJson(), ShowCodingParms.class);
            Long l = null;
            Long l2 = null;
            if (showCodingParms.getScanBatchId() != null) {
                l = showCodingParms.getScanBatchId();
                logger.debug((Object)("Received ShowCoding ScanBatchId: " + l));
            }
            if (showCodingParms.getPatientFileId() != null) {
                l2 = showCodingParms.getPatientFileId();
                logger.debug((Object)("Received ShowCoding PatientFileId: " + l));
            }
            taskPlugin.showCodingPage(l, l2);
        }
    }
    ,
    ShowScanBatch{

        @Override
        public void takeAction(ClientActionMessage clientActionMessage) {
            ShowScanBatch showScanBatch = (ShowScanBatch)gson.fromJson(clientActionMessage.getParmsJson(), ShowScanBatch.class);
            Long l = showScanBatch.getScanBatchId();
            boolean bl = showScanBatch.isEnableScanning();
            logger.debug((Object)("Received ShowScanBatch ScanBatchId: " + l + ", EnableScanning: " + bl));
            taskPlugin.showScanDetailPage(l.longValue(), bl);
        }
    };

    private static final Gson gson;
    private static final TaskPlugin taskPlugin;
    private static final Logger logger;

    public abstract void takeAction(ClientActionMessage var1);

    public static ClientActionEnum enumFromString(String string) {
        ClientActionEnum clientActionEnum = null;
        if ("CreateScanBatch".equalsIgnoreCase(string)) {
            clientActionEnum = CreateScanBatch;
        } else if ("ShowCoding".equalsIgnoreCase(string)) {
            clientActionEnum = ShowCoding;
        } else if ("ShowScanBatch".equalsIgnoreCase(string)) {
            clientActionEnum = ShowScanBatch;
            logger.error((Object)("don't know how to handle '" + string + "'"));
        }
        return clientActionEnum;
    }

    static {
        gson = new Gson();
        taskPlugin = (TaskPlugin)DependencyInjector.getInstance(TaskPlugin.class);
        logger = LoggerHelper.getLogger();
    }
}

