/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client;

import a8.hermes.protocol.SendMessageRequest;
import a8.hermes.protocol.SendMessageResponse;
import com.ahsrcm.batchviewer.client.hermes.ClientHermesClient;
import com.ahsrcm.core.hermes.ClientHeartbeatMessage;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class PingHeartbeater {
    private static final Logger logger = LoggerHelper.getLogger();
    private final Gson _gson = new Gson();
    private final AtomicBoolean _isStarted = new AtomicBoolean(false);
    private final ThreadScheduler _threadScheduler;
    private final ClientHermesClient _hermesClient;
    private String _eaxUserId;

    @Inject
    public PingHeartbeater(ThreadScheduler threadScheduler, ClientHermesClient clientHermesClient) {
        this._threadScheduler = threadScheduler;
        this._hermesClient = clientHermesClient;
    }

    public void start(TimeDuration timeDuration, String string) {
        if (this._isStarted.compareAndSet(false, true)) {
            this._threadScheduler.scheduleRepeating("Heartbeat", timeDuration, false, (Runnable)new HeartbeatRunnable());
            this._eaxUserId = string;
        }
    }

    public class HeartbeatRunnable
    implements Runnable {
        @Override
        public void run() {
            try {
                logger.info((Object)("Sending heartbeat for user " + PingHeartbeater.this._eaxUserId));
                ClientHeartbeatMessage clientHeartbeatMessage = new ClientHeartbeatMessage(PingHeartbeater.this._eaxUserId);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("type", "Heartbeat");
                JsonObject jsonObject = (JsonObject)PingHeartbeater.this._gson.toJsonTree((Object)clientHeartbeatMessage);
                SendMessageRequest sendMessageRequest = new SendMessageRequest(Collections.singletonList(PingHeartbeater.this._hermesClient.getServerMailboxId().getValue()), hashMap, jsonObject);
                SendMessageResponse sendMessageResponse = PingHeartbeater.this._hermesClient.getClient().send(sendMessageRequest);
                List list = sendMessageResponse.getFailures();
                if (list.isEmpty()) {
                    logger.debug((Object)"heartbeat to server successful");
                } else {
                    String string = String.join((CharSequence)",", list);
                    logger.warn((Object)("heartbeat to server failed. failures = " + string));
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"Error sending heartbeat to server", (Object)exception);
            }
        }
    }
}

