/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client;

import com.ahsrcm.batchviewer.client.BatchViewerPanel;
import com.ahsrcm.client.scanning.gui.PanelPopupHelper;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.dto.ScanBatchDTO;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JFrame;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class BatchViewerWindow {
    private static final Logger logger = LoggerHelper.getLogger();
    @Inject
    ClientScanningDao _dao;
    @Inject
    PanelPopupHelper _panelPopupHelper;
    JFrame _frame;
    BatchViewerPanel _batchViewerPanel;

    public void setupAndShow(long l) {
        PatientFile patientFile3;
        ScanBatch scanBatch = this._dao.loadScanBatch(0L, l);
        PatientFile patientFile2 = null;
        for (PatientFile patientFile3 : scanBatch.patientFiles) {
            if (!((Long)patientFile3.id.get()).equals(l)) continue;
            patientFile2 = patientFile3;
            break;
        }
        try {
            Iterator iterator = scanBatch.getCDLEntity().getDatabase();
            logger.debug((Object)"database: {}", ((Database)iterator).id.get());
        }
        catch (Exception exception) {
            logger.warn((Object)"Could not retrieve database");
        }
        logger.trace((Object)"creating gui frame");
        patientFile3 = this._dao.getScanBatchDTO(scanBatch.getId().longValue());
        this._frame = new JFrame();
        this._frame.setTitle(String.format("Batch Viewer - %s", patientFile2.id + ""));
        this._batchViewerPanel = new BatchViewerPanel(this._frame, patientFile2.getCompany().getCPTCodes(), (ScanBatchDTO)patientFile3);
        this._batchViewerPanel.setPatientFile(patientFile2);
        this._frame.setLayout(new BorderLayout());
        this._frame.add((Component)((Object)this._batchViewerPanel), "Center");
        this._frame.pack();
        this._frame.setVisible(true);
        this._panelPopupHelper.addVisibleFrame(this._frame);
        logger.trace((Object)"created gui frame");
    }

    public void closeWindow() {
        if (this._frame != null) {
            logger.debug((Object)"closing window for frame {}", (Object)this._frame);
            this._frame.setVisible(false);
            this._frame.dispose();
        }
    }

    public BatchViewerPanel getBatchViewerPanel() {
        return this._batchViewerPanel;
    }
}

