/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client;

import com.ahsrcm.client.scanning.StandaloneAppTaskPluginHelperImpl;
import com.ahsrcm.client.scanning.gui.CodingPanel;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.dto.CompanyCPTCodes;
import com.ahsrcm.corp.dto.ScanBatchDTO;
import java.awt.Graphics;
import javax.swing.JFrame;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3x.swing.M3Panel;

public class BatchViewerPanel
extends M3Panel {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 4615389599006622817L;
    boolean _initialSnapitDone = false;
    final CodingPanel _codingPanel;
    final JFrame _frame;
    ScanBatch _scanBatch;
    PatientFile _patientFile;

    public BatchViewerPanel(JFrame jFrame, CompanyCPTCodes companyCPTCodes, ScanBatchDTO scanBatchDTO) {
        super("fill, ins 0");
        this._frame = jFrame;
        this._codingPanel = new CodingPanel(null, companyCPTCodes, scanBatchDTO);
        this.add(this._codingPanel.getPanel(), "grow");
    }

    public void paint(Graphics graphics) {
        if (!this._initialSnapitDone) {
            this._initialSnapitDone = true;
            this._codingPanel.getImageViewer().snapWindowsToPresets();
        }
        super.paint(graphics);
    }

    void closeCodingPanelWindow() {
        this._frame.setVisible(false);
    }

    public void setPatientFile(PatientFile patientFile) {
        if (patientFile == null) {
            logger.warn((Object)"setPatientFile was called on a null PatientFile");
            return;
        }
        this._codingPanel.setPatientFile(patientFile, true);
        Company company = patientFile.getCompany();
        if (!((String)company.id.get()).equals(patientFile.getCDLEntity().getCompanyId())) {
            this._codingPanel.setCptCodes(patientFile.getCompany().getCPTCodes());
        }
        this._patientFile = patientFile;
        this._scanBatch = this._patientFile.getBatch();
    }

    public void nextPage() {
        this._codingPanel.getImageViewer().nextPage();
    }

    public PatientFile getPatientFile() {
        return this._patientFile;
    }

    public void previousPage() {
        this._codingPanel.getImageViewer().previousPage();
    }

    public void loadPatientFile(String string) {
        Long l = Long.valueOf(string);
        PatientFile patientFile = ((StandaloneAppTaskPluginHelperImpl)DependencyInjector.get().getInstance(StandaloneAppTaskPluginHelperImpl.class)).getVisit(Long.valueOf(0L), l);
        this.setPatientFile(patientFile);
        this._frame.setTitle(String.format("Batch Viewer - %s", l));
        this._frame.setVisible(true);
    }
}

