/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client;

import com.ahsrcm.client.launcher.StubbyLauncher;
import com.ahsrcm.client.scanning.gui.PanelPopupHelper;
import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.login.LoginTool;
import com.ahsrcm.scanning.rpc.ProviderUpStreamUrlProviderForClient;
import com.google.inject.Inject;
import java.awt.Window;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3x.swing.domviewer.ComponentTreeModelBuilder;

public class BatchViewerClientAppDev {
    private static final Logger logger = LoggerHelper.getLogger();
    Properties _buildProperties;
    String _serverUrl = this.getProperty("serverUrl");
    String _commandLine = this.getProperty("commandLine");
    String _cacheServerUrl = this.getProperty("cacheServerUrl");
    boolean _addSessionIdToCommandLine = false;
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    ProviderUpStreamUrlProviderForClient _upStreamServerUrlProvider;
    @Inject
    LoginTool _loginTool;
    @Inject
    PanelPopupHelper _panelPopupHelper;

    public static void main(String[] stringArray) throws Exception {
        try {
            ((BatchViewerClientAppDev)DependencyInjector.getInstance(BatchViewerClientAppDev.class)).run();
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable);
        }
    }

    void run() throws Exception {
        Object object;
        String string = this.getProperty("addSessionIdToCommandLine");
        if (string != null && string.toLowerCase().equals("true")) {
            this._addSessionIdToCommandLine = true;
        }
        if (this._addSessionIdToCommandLine) {
            object = this.login();
            if (object != null) {
                this._commandLine = this._commandLine + " -sessionId " + (String)object;
            } else {
                JOptionPane.showConfirmDialog(null, "login failed make sure you have a build.properites file properly setup");
            }
        }
        if (this._cacheServerUrl != null) {
            this._upStreamServerUrlProvider.setCacheServersFromClientConfig(ListX.create((Object[])new UrlX[]{new UrlX(this._cacheServerUrl)}));
        }
        this._serverUrlProvider.set((Object)new UrlX(this._serverUrl).getRootUrl());
        StubbyLauncher.main((String[])this._commandLine.split(" "));
        object = this._panelPopupHelper.showDeveloperHelperPanel();
        ComponentTreeModelBuilder.registerHotkey();
        ComponentTreeModelBuilder.addFrameMenus();
        ((Window)object).pack();
    }

    String login() {
        String string = this.getProperty("eaxUser");
        String string2 = this.getProperty("eaxPassword");
        return this._loginTool.login(string, string2);
    }

    void loadProperties(Directory directory) {
        File file;
        Directory directory2 = directory.getParent();
        if (directory2 != null) {
            this.loadProperties(directory2);
        }
        if ((file = new File(directory, "build.properties")).exists()) {
            try {
                logger.debug((Object)"loading properties {}", (Object)file.getCanonicalPath());
                this._buildProperties.load(file.createInputStream());
            }
            catch (Exception exception) {
                LoggerHelper.getLogger().warn((Object)exception);
            }
        }
    }

    String getProperty(String string) {
        if (this._buildProperties == null) {
            this._buildProperties = new Properties();
            this._buildProperties.putAll((Map<?, ?>)System.getProperties());
            this.loadProperties(new Directory("."));
        }
        return this._buildProperties.getProperty(string);
    }
}

