/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.batchviewer.client;

import com.ahsrcm.batchviewer.client.BatchViewerWindow;
import com.ahsrcm.batchviewer.client.PingHeartbeater;
import com.ahsrcm.batchviewer.client.hermes.ClientHermesClient;
import com.ahsrcm.client.launcher.StubbyApp;
import com.ahsrcm.client.launcher.StubbyLauncher;
import com.ahsrcm.client.scanning.ClscanImageSource;
import com.ahsrcm.client.scanning.gui.PanelPopupHelper;
import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.UserAhsDirectory;
import com.ahsrcm.client.tools.login.LoginPopup;
import com.ahsrcm.client.tools.login.LoginTool;
import com.ahsrcm.client.tools.login.NotAuthorizedException;
import com.ahsrcm.core.logs.LogSender;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.SecurityToken;
import com.ahsrcm.corp.User;
import com.ahsrcm.scanning.app.client.ImageUploadService;
import com.ahsrcm.scanning.app.client.TaskPlugin;
import com.ahsrcm.scanning.app.client.beans.CorrespondenceScanningInfo;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.rpc.ProviderUpStreamUrlProviderForClient;
import com.ahsrcm.scanning.rpc.UpStreamServerUrlProvider;
import com.ahsrcm.util.ForbiddenException;
import com.ahsrcm.util.UserContext;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.guice.LifeCycleManager;
import net.model3.guice.bootstrap.CacheDirectory;
import net.model3.lang.StringX;
import net.model3.lang.SystemX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Level;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

@Singleton
public class BatchViewerClientApp
implements StubbyApp {
    private static final Logger logger = LoggerHelper.getLogger();
    @Inject
    DeployEdgeProperties _deployEdgeProperties;
    @Inject
    Injector _injector;
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    ProviderUpStreamUrlProviderForClient _upStreamServerUrlProviderProvider;
    @Inject
    UpStreamServerUrlProvider _upStreamServerUrlProvider;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    ClientScanningDao _dao;
    @Inject
    TaskPlugin _taskPlugin;
    @Inject
    ThreadScheduler _threadScheduler;
    @Inject
    CacheDirectory _cacheDirectory;
    @Inject
    LoginTool _loginTool;
    @Inject
    ImageUploadService _imageUploadService;
    @Inject
    ClientHermesClient _hermesClient;
    @Inject
    PingHeartbeater _pingHeartbeater;
    @Inject
    LoginPopup _loginPopup;
    @Inject
    PanelPopupHelper _panelPopupHelper;
    boolean _initialDataLoaded = false;
    @Inject
    LifeCycleManager _lifeCycleManager;
    LoginPopup.CallBack _loginCallback = new LoginPopup.CallBack(){

        public void loggedIn(String string) {
            logger.debug((Object)"New session established");
            BatchViewerClientApp.this.setSessionId(string);
            BatchViewerClientApp.this.startHermesClient();
            BatchViewerClientApp.this.startPingHeartbeater();
        }

        public void cancelled() {
            logger.warn((Object)"Login was cancelled.");
        }
    };

    public static void main(String[] stringArray) {
        StubbyLauncher.main((String[])stringArray);
    }

    public void start() {
        logger.info((Object)"starting");
        this.createDeployEdgePropertiesSample();
        String string = MetalLookAndFeel.class.getName();
        if (StringX.isNotBlank((String)string)) {
            try {
                UIManager.setLookAndFeel(string);
                logger.info((Object)"look and feel set to {}", (Object)string);
            }
            catch (Throwable throwable) {
                logger.warn((Object)"unable to set look and feel to {}", (Object)string, (Object)throwable);
            }
        }
        if (this._serverUrlProvider.get() == null) {
            UrlX urlX = new UrlX(System.getProperty("app.url"));
            this._serverUrlProvider.set((Object)urlX.getRootUrl());
        }
        this.initCacheServerUrlsFromClientConfig();
        logger.debug((Object)this._serverUrlProvider);
        logger.debug((Object)this._upStreamServerUrlProvider);
        this.registerTrayIcon();
        if (StringX.isNotBlank((String)((String)this._sessionIdProvider.get()))) {
            this.setSessionId((String)this._sessionIdProvider.get());
        }
        if (this._deployEdgeProperties.getLogAllSpecs().booleanValue()) {
            ClscanImageSource.logAllSpecs();
        }
        this._lifeCycleManager.config.fire();
    }

    private void initCacheServerUrlsFromClientConfig() {
        String string = this._deployEdgeProperties.getCacheServerUrl();
        List list = ListX.create();
        for (String string2 : string.split(",")) {
            if (StringX.isBlank((String)string2)) continue;
            list.add(new UrlX(string2.trim()));
        }
        this._upStreamServerUrlProviderProvider.setCacheServersFromClientConfig(list);
    }

    public Component getMainView() {
        return null;
    }

    public String appName() {
        return "batchviewer";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommandLine(String string) {
        logger.debug((Object)("processing command line -- " + string));
        string = string.trim();
        List list = ListX.create();
        for (String string2 : string.split(" ")) {
            if (!StringX.isNotBlank((String)string2)) continue;
            String string3 = string2.trim();
            list.add(string3);
        }
        if (list.size() > 0) {
            String string4 = (String)list.get(0);
            if (string4.equals("-token")) {
                this.processSecurityToken((String)list.get(1));
            } else if (list.size() == 1 && string4.startsWith("TKN")) {
                this.processSecurityToken(string4);
            } else {
                String string5;
                int n = list.indexOf("-sessionId");
                if (n >= 0 && StringX.isNotBlank((String)(string5 = (String)list.get(n + 1)))) {
                    this.setSessionId(string5);
                }
                if (string4.equals("-createScanBatch")) {
                    this._taskPlugin.showCreateScanBatch();
                } else if (string4.equals("-scanBatch")) {
                    long l = Long.valueOf((String)list.get(1));
                    boolean bl = Boolean.valueOf((String)list.get(2));
                    this._taskPlugin.showScanDetailPage(l, bl);
                } else if (string4.equals("-coding")) {
                    String string6 = (String)list.get(1);
                    long l = Long.valueOf((String)list.get(2));
                    if (string6.equals("-batchId")) {
                        this._taskPlugin.showCodingPage(Long.valueOf(l), null);
                    } else {
                        if (!string6.equals("-patientFileId")) throw new RuntimeException("don't know how to handle " + string6);
                        this._taskPlugin.showCodingPage(null, Long.valueOf(l));
                    }
                } else if (string4.equals("-debug")) {
                    String string7 = this._loginTool.login();
                    if (string7 != null) {
                        this._loginCallback.loggedIn(string7);
                    }
                    this._panelPopupHelper.showDeveloperHelperPanel();
                } else if (string4.equals("-correspondence")) {
                    String string2;
                    String string8 = (String)list.get(list.indexOf("-token") + 1);
                    this.processSecurityToken(string8, false);
                    string2 = this.parseCommandToCorrespondenceScanningInfo(string);
                    this._taskPlugin.showCorrespondence((CorrespondenceScanningInfo)string2);
                }
            }
        }
        this._imageUploadService.tickle();
        this.initHermesClient();
    }

    CorrespondenceScanningInfo parseCommandToCorrespondenceScanningInfo(String string) {
        List list = ListX.create((Object[])new String[]{"company", "division", "location", "batchType", "patientL", "patientR", "encounter", "doctor"});
        Map map = MapX.create();
        for (String string2 : string.split(" ")) {
            String string3 = string2.trim();
            for (String string4 : list) {
                String string5 = "-D" + string4;
                int n = string5.length() + 1;
                if (string3.startsWith(string4)) {
                    map.put(string4, string3);
                    continue;
                }
                if (!string3.startsWith(string5)) continue;
                map.put(string4, string3.substring(n));
            }
        }
        CorrespondenceScanningInfo correspondenceScanningInfo = new CorrespondenceScanningInfo((String)map.get("company"), (String)map.get("division"), (String)map.get("location"), (String)map.get("batchType"), (String)map.get("patientL"), (String)map.get("patientR"), (String)map.get("encounter"), (String)map.get("doctor"));
        return correspondenceScanningInfo;
    }

    User getCurrentUser() {
        return ((UserContext)this._injector.getInstance(UserContext.class)).getUser();
    }

    void setSessionId(String string) {
        if (StringX.isBlank((String)string)) {
            throw new RuntimeException("invalid session = " + string);
        }
        if (!string.equals(this._sessionIdProvider.get())) {
            User user = this.getCurrentUser();
            String string2 = null;
            try {
                string2 = this._loginTool.getUserLoginName(string);
            }
            catch (NotAuthorizedException notAuthorizedException) {
                String string3 = "Invalid Session ID. Please exit and login again.\n";
                JOptionPane.showMessageDialog(null, string3, "AHS Deploy Edge Message", 1);
                logger.debug((Object)"unable to set session id - {}", (Object)string3);
                throw new ForbiddenException("Invalid Session ID - unable to determine user login name from session id - " + string);
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
            if (user != null && !((String)user.loginName.get()).equals(string2)) {
                logger.debug((Object)"user has switched {} != {}", user.loginName.get(), (Object)string2);
                String string4 = "A user different than the one logged in made a request.\nThe request will be ignored.  Perhaps you user switched\nand forgot to close DeployEdge.  To successfully make\nthe request close DeployEdge via the AHS tray icon and\nmake request again.";
                JOptionPane.showMessageDialog(null, string4, "AHS Deploy Edge Message", 1);
                throw new ForbiddenException("User " + user + " already logged in cannot switch to " + string2);
            }
            this._sessionIdProvider.set((Object)string);
            if (!this._initialDataLoaded) {
                this._dao.initialDataLoad();
                this.recordUser();
                this._initialDataLoaded = true;
                this.scheduleScanningServerHeartbeats();
            }
        }
    }

    void recordUser() {
        try {
            User user = this.getCurrentUser();
            File file = new File((Directory)this._cacheDirectory.get(), "lastUser");
            FileWriter fileWriter = file.createWriter();
            fileWriter.write((String)user.id.get());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            logger.error((Object)"Error recording user", (Object)exception);
        }
    }

    void scheduleScanningServerHeartbeats() {
        TimeDuration timeDuration = new TimeDuration("1 minute");
        this._threadScheduler.scheduleRepeating("memorylog", timeDuration, false, new Runnable(){

            @Override
            public void run() {
                SystemX.logMemoryUsage();
            }
        });
    }

    void processSecurityToken(String string) {
        this.processSecurityToken(string, true);
    }

    void processSecurityToken(String string, boolean bl) {
        this.setSessionId(string);
        SecurityToken securityToken = this._dao.resolveSecurityToken(string);
        long l = securityToken.getPatientFileId();
        if (bl) {
            String string2 = securityToken.getType();
            if (string2 != null && string2.equalsIgnoreCase("BAT")) {
                try {
                    ScanBatch scanBatch = this._dao.loadScanBatch(0L, l);
                    long l2 = scanBatch.getId();
                    this._taskPlugin.showScanDetailPage(l2, true);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn((Object)("Couldn't display ScanBatch tied to PatientFileId:  " + l), (Object)numberFormatException);
                }
            }
            BatchViewerWindow batchViewerWindow = (BatchViewerWindow)this._injector.getInstance(BatchViewerWindow.class);
            batchViewerWindow.setupAndShow(l);
        }
    }

    void registerTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource("HealthPrimeLogo.png"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){};
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("Exit");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    logger.debug((Object)"Exit from tray menu");
                    System.exit(0);
                }
            });
            MenuItem menuItem2 = new MenuItem("Send Logs");
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new Thread(){
                        {
                            this.setName("log-sender-" + this.getId());
                        }

                        @Override
                        public void run() {
                            try {
                                ((LogSender)BatchViewerClientApp.this._injector.getInstance(LogSender.class)).run();
                            }
                            catch (Exception exception) {
                                logger.error((Object)"error sending logs", (Object)exception);
                            }
                        }
                    }.start();
                }
            });
            popupMenu.add(menuItem2);
            popupMenu.add(menuItem);
            TrayIcon trayIcon = new TrayIcon(bufferedImage, "DeployEdge Launcher", popupMenu);
            trayIcon.setImageAutoSize(true);
            trayIcon.addMouseListener(mouseAdapter);
            trayIcon.addMouseMotionListener(mouseAdapter);
            try {
                systemTray.add(trayIcon);
            }
            catch (AWTException aWTException) {
                logger.error((Object)"TrayIcon could not be added.", (Object)aWTException);
            }
        } else {
            logger.debug((Object)"System Tray is not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDeployEdgePropertiesSample() {
        try {
            String string = "deployedge.properties.sample";
            java.io.File file = new java.io.File(UserAhsDirectory.get(), string);
            logger.debug((Object)("outputting " + file.getAbsolutePath()));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) >= 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
            }
            finally {
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARN, new Object[]{"unable to create deployedge.properties.sample", exception});
        }
    }

    public void initHermesClient() {
        try {
            String string;
            Boolean bl = this._deployEdgeProperties.getRequireEaxLoginOnStartup();
            String string2 = this._deployEdgeProperties.getLongLivedEaxSessionId();
            if (!string2.trim().equals("")) {
                this._sessionIdProvider.set((Object)string2);
            }
            if ((string = (String)this._sessionIdProvider.get()) == null || string.trim().equals("")) {
                if (bl.booleanValue()) {
                    this._loginPopup.showLogin(this._loginCallback);
                } else {
                    logger.info((Object)"skipping hermes client init because there is no session in scope.");
                }
            } else {
                this.startHermesClient();
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Unable to start hermes client", (Object)exception);
        }
    }

    void startHermesClient() {
        logger.debug((Object)"starting hermes client");
        UrlX urlX = (UrlX)this._serverUrlProvider.get();
        String string = (String)this._sessionIdProvider.get();
        String string2 = this._loginTool.getUserId(string);
        this._hermesClient.start(urlX, string2);
    }

    void startPingHeartbeater() {
        TimeDuration timeDuration = this._deployEdgeProperties.getHeartbeatFrequency();
        String string = (String)this._sessionIdProvider.get();
        String string2 = this._loginTool.getUserId(string);
        this._pingHeartbeater.start(timeDuration, string2);
    }
}

