/*
 * Decompiled with CFR 0.152.
 */
package a8.hermes;

import a8.hermes.HttpClient;
import a8.hermes.protocol.CreateMailboxResponse;
import a8.hermes.protocol.PrivateMailboxId;
import a8.hermes.protocol.PubPrivPair;
import a8.hermes.protocol.PublicMailboxId;
import com.google.gson.Gson;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxResolver {
    private static final Logger logger = LoggerFactory.getLogger(MailboxResolver.class);

    public static PubPrivPair create(URI uRI, PubPrivPair pubPrivPair) {
        PubPrivPair pubPrivPair2 = null;
        int n = 0;
        Gson gson = new Gson();
        URI uRI2 = pubPrivPair == null ? uRI.resolve("api/createMailbox") : uRI.resolve("api/createLinkedMailbox?privateMailboxId=" + pubPrivPair.getPrivateMailboxId().getValue() + "&" + "publicMailboxId" + "=" + pubPrivPair.getPublicMailboxId().getValue());
        while (pubPrivPair2 == null) {
            try {
                String string = HttpClient.get(uRI2);
                CreateMailboxResponse createMailboxResponse = (CreateMailboxResponse)gson.fromJson(string, CreateMailboxResponse.class);
                pubPrivPair2 = new PubPrivPair(new PublicMailboxId(createMailboxResponse.getPublicMailboxId()), new PrivateMailboxId(createMailboxResponse.getPrivateMailboxId()));
            }
            catch (Exception exception) {
                if (n < 5) {
                    logger.warn("Error creating mailbox", (Throwable)exception);
                } else {
                    logger.warn("Error creating mailbox -- " + exception.getMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
        logger.debug("Created mailbox " + pubPrivPair2.toString());
        return pubPrivPair2;
    }
}

