/*
 * Decompiled with CFR 0.152.
 */
package a8.hermes;

import a8.hermes.Client;
import a8.hermes.HttpClient;
import a8.hermes.HttpException;
import a8.hermes.MailboxResolver;
import a8.hermes.MessageReceiver;
import a8.hermes.URIUtils;
import a8.hermes.protocol.Message;
import a8.hermes.protocol.PubPrivPair;
import a8.hermes.protocol.ReceiveMessagesRequest;
import a8.hermes.protocol.ReceiveMessagesResponse;
import a8.hermes.protocol.SendMessageRequest;
import a8.hermes.protocol.SendMessageResponse;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollClient
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(LongPollClient.class);
    private final URI hermesServerUri;
    private final MessageReceiver messageReceiver;
    private final int maxMessages;
    private final int timeoutInMillis;
    private final PubPrivPair namedPubPrivPair;
    private volatile boolean isMailboxSet = false;
    private PubPrivPair mailbox = null;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private boolean isStopped = false;
    private final Gson gson = new Gson();

    public LongPollClient(URI uRI, MessageReceiver messageReceiver) throws URISyntaxException {
        this(uRI, messageReceiver, null);
    }

    public LongPollClient(URI uRI, MessageReceiver messageReceiver, PubPrivPair pubPrivPair) throws URISyntaxException {
        this(uRI, messageReceiver, 50, 30000, pubPrivPair);
    }

    public LongPollClient(URI uRI, MessageReceiver messageReceiver, int n, int n2, PubPrivPair pubPrivPair) throws URISyntaxException {
        this.hermesServerUri = uRI.toString().endsWith("/") ? uRI : new URI(uRI.toString() + "/");
        this.messageReceiver = messageReceiver;
        this.maxMessages = n;
        this.timeoutInMillis = n2;
        this.namedPubPrivPair = pubPrivPair;
    }

    @Override
    public URI getHermesServerUri() {
        return this.hermesServerUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PubPrivPair getMailbox() {
        LongPollClient longPollClient = this;
        synchronized (longPollClient) {
            if (!this.isMailboxSet) {
                this.mailbox = MailboxResolver.create(this.hermesServerUri, this.namedPubPrivPair);
                this.isMailboxSet = true;
            }
        }
        return this.mailbox;
    }

    @Override
    public SendMessageResponse send(SendMessageRequest sendMessageRequest) throws IOException, HttpException {
        URI uRI = this.getSendMessageUri();
        String string = this.gson.toJson((Object)sendMessageRequest);
        String string2 = HttpClient.post(uRI, string);
        return (SendMessageResponse)this.gson.fromJson(string2, SendMessageResponse.class);
    }

    @Override
    public void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            new Thread(){
                {
                    this.setName("hermes-long-poll-" + this.getId());
                }

                @Override
                public void run() {
                    try {
                        logger.info("Thread started");
                        LongPollClient.this.runLongPoll();
                    }
                    catch (Exception exception) {
                        logger.error("Unhandled exception in thread", (Throwable)exception);
                    }
                    finally {
                        logger.info("Thread stopped");
                    }
                }
            }.start();
        }
    }

    @Override
    public void stop() {
        this.isStopped = true;
    }

    private URI getSendMessageUri() {
        PubPrivPair pubPrivPair = this.getMailbox();
        String string = URIUtils.encodeURIComponent(pubPrivPair.getPrivateMailboxId().getValue());
        String string2 = URIUtils.encodeURIComponent(pubPrivPair.getPublicMailboxId().getValue());
        return this.hermesServerUri.resolve("api/send?privateMailboxId=" + string + "&" + "publicMailboxId" + "=" + string2);
    }

    private URI getReceiveMessageUri() {
        PubPrivPair pubPrivPair = this.getMailbox();
        String string = URIUtils.encodeURIComponent(pubPrivPair.getPrivateMailboxId().getValue());
        String string2 = URIUtils.encodeURIComponent(pubPrivPair.getPublicMailboxId().getValue());
        return this.hermesServerUri.resolve("api/receive?privateMailboxId=" + string + "&" + "publicMailboxId" + "=" + string2);
    }

    private void runLongPoll() {
        String string = null;
        URI uRI = this.getReceiveMessageUri();
        while (!this.isStopped) {
            try {
                ReceiveMessagesRequest receiveMessagesRequest = new ReceiveMessagesRequest(string, this.maxMessages, this.timeoutInMillis);
                String string2 = this.gson.toJson((Object)receiveMessagesRequest);
                String string3 = HttpClient.post(uRI, string2);
                ReceiveMessagesResponse receiveMessagesResponse = (ReceiveMessagesResponse)this.gson.fromJson(string3, ReceiveMessagesResponse.class);
                for (Message message : receiveMessagesResponse.getMessages()) {
                    try {
                        this.messageReceiver.receiveFn(message);
                    }
                    catch (Exception exception) {
                        logger.warn("Error processing msg " + message.toString(), (Throwable)exception);
                    }
                }
                string = receiveMessagesResponse.getNextOffset();
            }
            catch (HttpException httpException) {
                if (httpException.getCode() == 404) {
                    this.isMailboxSet = false;
                    uRI = this.getReceiveMessageUri();
                    continue;
                }
                logger.warn("Error retrieving messages", (Throwable)httpException);
            }
            catch (Exception exception) {
                logger.warn("Error retrieving messages", (Throwable)exception);
            }
        }
    }
}

